/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于常规参数页面
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.7.31
 *      内容 : 所有代码
 *************************************************************************************************/

/* global mc_sdk_param */
/* global mc_ui_lab */

/* exported mc_get_status_code_html */


/* ********************** FC ********************************* */
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取状态码dom字符串
 * 参数:
 *    @param { Promise<String> } str_json json字串
 * 返回:
 *    @returns { Promise<String> } html 字符串 || ""
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-28
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_status_code_html(str_json) {
    var str_res_html = "";

    if ("string" !== typeof str_json) {
        return str_res_html;
    }

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_json(str_json);

    // console.log(JSON.parse(str_json));

    // 错误码和亮度有效率
    var err_code = obj_sdk_param.get_param_value("ERROR_CODE");
    var err_code_val = obj_sdk_param.get_param_value("LUMI_EFFICT");

    // 状态码
    var obj_status_lab = new mc_ui_lab();
    var str_lab = "";
    var obj_status_val = new mc_ui_lab();
    var str_val = "";

    if (!err_code || ("string" === typeof err_code && !err_code.trim())) {
        return str_res_html;
    }

    var obj2_status_lab = new mc_ui_lab();
    var obj2_status_val = new mc_ui_lab();
    var str_lab2 = "";
    var str_val2 = "";
    var str_html2 = "";


    // if (err_code && err_code_val) {
    switch (err_code) {
    case "-1":
        return str_res_html;
    case "0":
        str_val = err_code_val + "";
        str_lab = "MC_LANG_EFFECTIVE_BRIGHTNESS";
        break;
    case "4097":
        str_val = "MC_LANG_STATUS_CODE_" + err_code;
        str_lab = "MC_LANG_STATUS_WARNOING";
        obj_status_lab.set_style_color("#E6A23C");
        obj_status_val.set_style_color("#E6A23C");
        break;
    default:
        str_val = "MC_LANG_STATUS_CODE_" + err_code;
        str_lab = "MC_LANG_STATUS_ERROR";
        obj_status_lab.set_style_color("red");
        obj_status_val.set_style_color("red");
        break;
    }

    // 设置名称
    obj_status_lab.set_title(str_lab);
    obj_status_lab.set_val(str_lab);

    // 设置值
    obj_status_val.set_val(str_val);
    // }

    str_res_html = obj_status_lab.get_html_txt() + obj_status_val.get_html_txt();

    // 显示灰阶超时 还要显示亮度有效值 特殊处理添加第二个参数
    if ("4097" === err_code) {
        str_lab2 = "MC_LANG_EFFECTIVE_BRIGHTNESS";
        str_val2 = err_code_val + "";
        obj2_status_lab.set_title(str_lab2);
        obj2_status_lab.set_val(str_lab2);
        obj2_status_val.set_val(str_val2);
        str_html2 = obj2_status_lab.get_html_txt() + obj2_status_val.get_html_txt();
    }


    return [str_res_html, str_html2];
}

